int alpha = PREFIX(alpha);
float intensity = float(alpha)/100.0;
#define ChannelBlend_Exclusion(B,L)  ((B + L - ((B * L)*2.0)))


vec3 AdjustforJigsaw_Spring(vec3 rgb)
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x,86.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y,2.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z,2.0/256.0);
	return outputCol;
}
vec3 AdjustforJigsaw_Summer(vec3 rgb)
{
	vec3 outputCol;
	outputCol.x= ChannelBlend_Exclusion(rgb.x, 21.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 59.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 7.0/256.0);
	return outputCol;
}

vec3 AdjustforJigsaw_Autumn(vec3 rgb)
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x, 16.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 5.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 99.0/256.0);
	return outputCol;
}
vec3 AdjustforJigsaw_Winter(vec3 rgb)
{
	vec3 outputCol;
	outputCol.x = ChannelBlend_Exclusion(rgb.x, 9.0/256.0);
	outputCol.y = ChannelBlend_Exclusion(rgb.y, 62.0/256.0);
	outputCol.z = ChannelBlend_Exclusion(rgb.z, 103.0/256.0);
	return outputCol;
}


vec4 FUNCNAME(vec2 tc)
 {
    vec4 textureColor = INPUT(tc);
    vec4 fragOutCol;
	vec2 uv = tc;
    vec4 inColor = INPUT( uv );
	vec4 col = vec4(0.0);
	float W = iResolution.x;
	float H = iResolution.y;
	
	float whiteGap = 0.00325;
	float colorGapX = 0.2453125;
	float colorGapX2 = 2.0*colorGapX;
	float colorGapX3 = 3.0*colorGapX;
	float whiteGapY = whiteGap*W/H;
	
	if( uv.x<colorGapX || ( uv.x< colorGapX2  && uv.x > colorGapX && uv.y < colorGapX) ||( uv.x<colorGapX3  && uv.x > colorGapX2 && uv.y < colorGapX3))
		col.xyz = AdjustforJigsaw_Autumn(inColor.xyz);
	else 
		col.xyz = AdjustforJigsaw_Spring(inColor.xyz);
	
	if( (uv.x >colorGapX &&  uv.x< colorGapX +whiteGap && uv.y>colorGapX) 
		||(uv.x >colorGapX2 &&  uv.x< colorGapX2 +whiteGap && uv.y>colorGapX && uv.y< colorGapX3)
		||(uv.x >colorGapX3 &&  uv.x< colorGapX3 +whiteGap && uv.y< colorGapX3)
		|| (uv.y>colorGapX && uv.y < colorGapX + whiteGapY && uv.x>colorGapX && uv.x < colorGapX2)
		|| (uv.y>colorGapX3 && uv.y<colorGapX3 + whiteGapY && uv.x >colorGapX2 && uv.x < colorGapX3 +whiteGap ))
		col.xyz = vec3(1.0);
		
	col.a = inColor.a;

	 return vec4(inColor.rgb, inColor.a)*(1.0 - intensity) + vec4(col.rgb, inColor.a)*intensity;
 }
 